package edu.uky.ai.rl.ex;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import edu.uky.ai.rl.Learner;
import edu.uky.ai.rl.Main;
import edu.uky.ai.rl.ProcessParser;
import edu.uky.ai.rl.Settings;
import edu.uky.ai.rl.StochasticProcess;
import edu.uky.ai.rl.learn.Balanced;
import edu.uky.ai.rl.learn.Exploiter;
import edu.uky.ai.rl.learn.Explorer;
import edu.uky.ai.rl.learn.Farsighted;
import edu.uky.ai.rl.learn.Nearsighted;
import edu.uky.ai.rl.learn.RandomLearner;

public class Test {

	// Set this to Settings.DEFAULT_GUI_DELAY to watch it happen!
	private static final int DELAY = 0; //Settings.DEFAULT_GUI_DELAY;

	// You can comment some of these out if you only want to compare certain learners.
	public static Learner[] LEARNERS = new Learner[] {
		new ExampleLearner(),
		new RandomLearner(),
		new Explorer(),
		new Exploiter(),
		new Nearsighted(),
		new Farsighted(),
		new Balanced()
	};
	
	// You can comment some of these out if you only want to test on certain problems.
	public static final String[] PROCESSES = new String[] {
		"benchmarks/small_01.dungeon",
		"benchmarks/small_02.dungeon",
		"benchmarks/small_03.dungeon",
		"benchmarks/small_04.dungeon",
		"benchmarks/small_05.dungeon",
		"benchmarks/small_06.dungeon",
		"benchmarks/small_07.dungeon",
		"benchmarks/small_08.dungeon",
		"benchmarks/small_09.dungeon",
		"benchmarks/small_10.dungeon",
		"benchmarks/medium_01.dungeon",
		"benchmarks/medium_02.dungeon",
		"benchmarks/medium_03.dungeon",
		"benchmarks/medium_04.dungeon",
		"benchmarks/medium_05.dungeon",
		"benchmarks/medium_06.dungeon",
		"benchmarks/medium_07.dungeon",
		"benchmarks/medium_08.dungeon",
		"benchmarks/medium_09.dungeon",
		"benchmarks/medium_10.dungeon",
		"benchmarks/large_01.dungeon",
		"benchmarks/large_02.dungeon",
		"benchmarks/large_03.dungeon",
		"benchmarks/large_04.dungeon",
		"benchmarks/large_05.dungeon",
		"benchmarks/large_06.dungeon",
		"benchmarks/large_07.dungeon",
		"benchmarks/large_08.dungeon",
		"benchmarks/large_09.dungeon",
		"benchmarks/large_10.dungeon",
	};
	
	public static void main(String[] args) throws Exception {
		ProcessParser parser = new ProcessParser();
		ArrayList<StochasticProcess> processes = new ArrayList<>();
		for(String url : PROCESSES)
			processes.add(parser.parse(new File(url)));
		try(OutputStream output = new BufferedOutputStream(new FileOutputStream(new File("results.html")))) {
			Main.benchmark(LEARNERS, processes.toArray(new StochasticProcess[processes.size()]), Settings.DEFAULT_TRAINING_NODE_LIMIT, Settings.DEFAULT_TRAINING_TIME_LIMIT, Settings.DEFAULT_EVALUATION_NODE_LIMIT, Settings.DEFAULT_EVALUATION_TIME_LIMIT, DELAY, output);
		}
	}
}
